CREATE TABLE AB18A01T00
(
	T01_ID_PETICION_ENVIO  		NUMBER(5)  			NOT NULL ,
	T02_ID_TIPO_ENVIO  			NUMBER(5) 	 		NOT NULL ,
	T06_ID_BOLETIN	    		NUMBER(5) 	 		NOT NULL ,
	T11_ID_ESTADO	  			NUMBER(5) 	 		NOT NULL ,
	T01_FECHA_ALTA  			DATE 				NOT NULL ,
	T01_ANUNCIO_ZIP				BLOB  				NULL ,
	T01_ANUNCIO_XML				CLOB  				NULL ,
	T01_ID_PODER				VARCHAR2(20) 	 		NULL ,
	T01_ID_ENTIDAD_IMP			VARCHAR2(20) 	 		NULL ,
	T01_ID_ORGANO				VARCHAR2(20) 			NULL,
	T01_ID_ENTIDAD_TRAM			VARCHAR2(20) 			NULL,
	T01_ID_MESA					VARCHAR2(20) 			NULL,
	T01_FECHA_PROGR_ENVIO		DATE 				NULL,
	T01_NUM_INTENTOS			NUMBER(3) 			NULL,
	T17_ID_ERROR_VALIDACION			NUMBER(3) 			NULL,
	T01_DATOS_ERROR				VARCHAR2(150) 		NULL,
	T01_ESTADO_TRAM				VARCHAR2(50) 		NULL,
	T01_COD_EXPEDIENTE			VARCHAR2(33)		NULL,
	T01_RESULT_VALID_LOGICA		CLOB  				NULL ,
	T01_ANUNCIO_XML_CONVERTIDO	CLOB  				NULL ,
	T07_ID_TICKET				NUMBER(5) 	 		NOT NULL ,
	T03_ID_APLICACION			NUMBER(5) 	 		NOT NULL,
	T01_ID_ORIGEN				NUMBER(14)			NOT NULL,
	T01_PARALIZADA				NUMBER(1)           NOT NULL
)
	TABLESPACE AB18A01E00   
	LOB (T01_ANUNCIO_XML) STORE AS AB18A01SL00  ( 
	TABLESPACE AB18A01E00
	DISABLE STORAGE IN ROW
	NOCACHE LOGGING)
	LOB (T01_RESULT_VALID_LOGICA) STORE AS AB18A02SL00  ( 
	TABLESPACE AB18A01E00
	DISABLE STORAGE IN ROW
	NOCACHE LOGGING)
	LOB (T01_ANUNCIO_XML_CONVERTIDO) STORE AS AB18A03SL00  ( 
	TABLESPACE AB18A01E00
	DISABLE STORAGE IN ROW
	NOCACHE LOGGING);


COMMENT ON TABLE AB18A01T00 IS 'PETICIONES DE ENVIO. Almacena las peticiones de envío de boletines a los servicios de publicación';


COMMENT ON COLUMN AB18A01T00.T01_ID_PETICION_ENVIO IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A01T00.T02_ID_TIPO_ENVIO IS 'Identificativo del tipo de envío.';

COMMENT ON COLUMN AB18A01T00.T06_ID_BOLETIN IS 'Identificador del boletín.';

COMMENT ON COLUMN AB18A01T00.T11_ID_ESTADO IS 'Identificador del estado en el que está la petición.';

COMMENT ON COLUMN AB18A01T00.T01_FECHA_ALTA IS 'Fecha de alta de la petición de envío.';

COMMENT ON COLUMN AB18A01T00.T01_ANUNCIO_ZIP IS 'ZIP del fichero del anuncio.';

COMMENT ON COLUMN AB18A01T00.T01_ANUNCIO_XML IS 'XML del fichero del anuncio.';

COMMENT ON COLUMN AB18A01T00.T01_ID_PODER IS 'Id del poder adjudicador. Se envía al servicio de publicación pero no coincide con un Id de ninguna tabla del sistema.';

COMMENT ON COLUMN AB18A01T00.T01_ID_ENTIDAD_IMP IS 'Id de la entidad impulsora. No corresponde con ninguna tabla del sistema.';

COMMENT ON COLUMN AB18A01T00.T01_ID_ORGANO IS 'Id del órgano de contratación. No se corresponde con ninguna tabla del sistema.';

COMMENT ON COLUMN AB18A01T00.T01_ID_ENTIDAD_TRAM IS 'Id de la entidad tramitadora. No se corresponde con ninguna tabla del sistema.';

COMMENT ON COLUMN AB18A01T00.T01_ID_MESA IS 'Id de la mesa. Dato para la publicación, no se corresponde con ninguna tabla del sistema.';

COMMENT ON COLUMN AB18A01T00.T01_FECHA_PROGR_ENVIO IS 'Fecha programada de envío.';

COMMENT ON COLUMN AB18A01T00.T01_NUM_INTENTOS IS 'Número de intentos realizados. Por defecto 0.';

COMMENT ON COLUMN AB18A01T00.T17_ID_ERROR_VALIDACION IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A01T00.T01_DATOS_ERROR IS 'Información del motivo del rechazo del envío.';

COMMENT ON COLUMN AB18A01T00.T01_ESTADO_TRAM IS 'Estado de tramitación. No se corresponde con estado del sistema, sino proporcionado por los servicios de publicación.';

COMMENT ON COLUMN AB18A01T00.T01_COD_EXPEDIENTE IS 'Código del expediente de tramitación asociado.';

COMMENT ON COLUMN AB18A01T00.T01_RESULT_VALID_LOGICA IS 'Informe del resultado de la validación lógica.';

COMMENT ON COLUMN AB18A01T00.T01_ANUNCIO_XML_CONVERTIDO	IS 'Anuncio XML convertido.';

COMMENT ON COLUMN AB18A01T00.T07_ID_TICKET	IS 'Id del ticket empleado para hacer la petición.';

COMMENT ON COLUMN AB18A01T00.T03_ID_APLICACION	IS 'Id de la aplicación que ha realizado la petición.';

COMMENT ON COLUMN AB18A01T00.T01_ID_ORIGEN	IS 'Id de origen en la aplicación que ha realizado la petición.';

COMMENT ON COLUMN AB18A01T00.T01_PARALIZADA	IS 'Flag que indica si la petición está paralizada.';

ALTER TABLE AB18A01T00
	ADD (CONSTRAINT  PK_AB18A01T00 PRIMARY KEY (T01_ID_PETICION_ENVIO)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

